/* ######################################################################### */
/* ##                                                                     ## */
/* ##  Dynamo / ostream64.h                                               ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Job .......: Extends the standard "ostream" class to provide input ## */
/* ##               and output of 64-bit integers.                        ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Intel Open Source License                                          ## */
/* ##                                                                     ## */
/* ##  Copyright (c) 2001 Intel Corporation                               ## */
/* ##  All rights reserved.                                               ## */
/* ##  Redistribution and use in source and binary forms, with or         ## */
/* ##  without modification, are permitted provided that the following    ## */
/* ##  conditions are met:                                                ## */
/* ##                                                                     ## */
/* ##  Redistributions of source code must retain the above copyright     ## */
/* ##  notice, this list of conditions and the following disclaimer.      ## */
/* ##                                                                     ## */
/* ##  Redistributions in binary form must reproduce the above copyright  ## */
/* ##  notice, this list of conditions and the following disclaimer in    ## */
/* ##  the documentation and/or other materials provided with the         ## */
/* ##  distribution.                                                      ## */
/* ##                                                                     ## */
/* ##  Neither the name of the Intel Corporation nor the names of its     ## */
/* ##  contributors may be used to endorse or promote products derived    ## */
/* ##  from this software without specific prior written permission.      ## */
/* ##                                                                     ## */
/* ##  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             ## */
/* ##  CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,      ## */
/* ##  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           ## */
/* ##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           ## */
/* ##  DISCLAIMED. IN NO EVENT SHALL THE INTEL OR ITS  CONTRIBUTORS BE    ## */
/* ##  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   ## */
/* ##  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,           ## */
/* ##  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,    ## */
/* ##  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    ## */
/* ##  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     ## */
/* ##  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT    ## */
/* ##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY    ## */
/* ##  OF SUCH DAMAGE.                                                    ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Remarks ...: <none>                                                ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Changes ...: 2003-10-19 (daniel.scheibli@edelbyte.org)             ## */
/* ##               - Changed the #ifdef behaviore to reflect the         ## */
/* ##                 original algorithm (using much easier code).        ## */
/* ##               2003-10-15 (daniel.scheibli@edelbyte.org)             ## */
/* ##               - Tried to cleanup the realy confusing #ifdef's at    ## */
/* ##                 the beginning of the file.                          ## */
/* ##               - Moved to the use of the IOMTR_[OSFAMILY|OS|CPU]_*   ## */
/* ##                 global defines.                                     ## */
/* ##               - Integrated the License Statement into this header.  ## */
/* ##               - Added new header holding the changelog.             ## */
/* ##                                                                     ## */
/* ######################################################################### */
#ifndef	OSTREAM64_DEFINED
#define OSTREAM64_DEFINED



// Uncomment if the workaround is needed. This
// - was needed prior to Win64 2239 IDW SDK and
// - is needed as of latest Win32 SDK
#if defined(IOMTR_OS_WIN32)
 //#define WORKAROUND_FOR_INT64_OFSTREAM

 #include <stdio.h>
 #include <ostream>
 using namespace std;

 #define INT64_DIGITS	21

 //
 // Extension to ostream to permit int64.
 //
 inline ostream& operator << ( ostream& s, _int64 i )
 {
     char buf[INT64_DIGITS];
     sprintf( buf, "%I64i", i );  
     return( s << buf );
 }

 //
 // Extension to ostream to permit unsigned int64.
 //
 inline ostream& operator << ( ostream& s, unsigned _int64 i )
 {
    char buf[INT64_DIGITS];
    sprintf( buf, "%I64i", i );
    return( s << buf );
 }

#elif defined(IOMTR_OS_WIN64)
 //#define WORKAROUND_FOR_INT64_OFSTREAM
#else
 #warning ===> WARNING: You have to do some coding here to get the port done!
#endif



#endif




