/* ######################################################################### */
/* ##                                                                     ## */
/* ##  Dynamo / NetVI.h                                                   ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Job .......: Class definition for the NetVI class.                 ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Intel Open Source License                                          ## */
/* ##                                                                     ## */
/* ##  Copyright (c) 2001 Intel Corporation                               ## */
/* ##  All rights reserved.                                               ## */
/* ##  Redistribution and use in source and binary forms, with or         ## */
/* ##  without modification, are permitted provided that the following    ## */
/* ##  conditions are met:                                                ## */
/* ##                                                                     ## */
/* ##  Redistributions of source code must retain the above copyright     ## */
/* ##  notice, this list of conditions and the following disclaimer.      ## */
/* ##                                                                     ## */
/* ##  Redistributions in binary form must reproduce the above copyright  ## */
/* ##  notice, this list of conditions and the following disclaimer in    ## */
/* ##  the documentation and/or other materials provided with the         ## */
/* ##  distribution.                                                      ## */
/* ##                                                                     ## */
/* ##  Neither the name of the Intel Corporation nor the names of its     ## */
/* ##  contributors may be used to endorse or promote products derived    ## */
/* ##  from this software without specific prior written permission.      ## */
/* ##                                                                     ## */
/* ##  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             ## */
/* ##  CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,      ## */
/* ##  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           ## */
/* ##  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           ## */
/* ##  DISCLAIMED. IN NO EVENT SHALL THE INTEL OR ITS  CONTRIBUTORS BE    ## */
/* ##  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   ## */
/* ##  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,           ## */
/* ##  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,    ## */
/* ##  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY    ## */
/* ##  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     ## */
/* ##  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT    ## */
/* ##  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY    ## */
/* ##  OF SUCH DAMAGE.                                                    ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Remarks ...: <none>                                                ## */
/* ##                                                                     ## */
/* ## ------------------------------------------------------------------- ## */
/* ##                                                                     ## */
/* ##  Changes ...: 2003-10-15 (daniel.scheibli@edelbyte.org)             ## */
/* ##               - Moved to the use of the IOMTR_[OSFAMILY|OS|CPU]_*   ## */
/* ##                 global defines.                                     ## */
/* ##               - Integrated the License Statement into this header.  ## */
/* ##               - Added new header holding the changelog.             ## */
/* ##                                                                     ## */
/* ######################################################################### */
#ifndef	NETVI_DEFINED
#define	NETVI_DEFINED



#include "IOCQVI.h"
#include "Network.h"



///////////////////////////////////////////////////////////////////////////////
// Abstracts VI message passing calls.
//
// Note that applications should verify that vipl.dll is loaded before using 
// this class.
//
///////////////////////////////////////////////////////////////////////////////
class NetVI
{
public:

	NetVI();

	///////////////////////////////////////////////////////////////////////////
	// Public functions used to communicate over a VI connection.
	//
	ReturnVal	Create( VINic *nic, TargetVI *vi_target );
	ReturnVal	Close();
	ReturnVal	CheckForDisconnect();
	//
	ReturnVal	Connect( VIP_NET_ADDRESS *local_nic_address, VIP_NET_ADDRESS *remote_nic_address );
	ReturnVal	Accept( VIP_NET_ADDRESS *local_nic_address );
	//
	ReturnVal	Send( VIP_DESCRIPTOR *descriptor, 
					VIP_MEM_HANDLE descriptor_handle );
	ReturnVal	Receive( VIP_DESCRIPTOR *descriptor, 
					VIP_MEM_HANDLE descriptor_handle );
	//
	///////////////////////////////////////////////////////////////////////////
	 

	///////////////////////////////////////////////////////////////////////////
	// Information about the VI connection.
	//
	VIP_VI_HANDLE	vi;
	VINic			*vi_nic;
	CQVI			vi_cq;
	//
	///////////////////////////////////////////////////////////////////////////


private:

	VIPL		vipl;		// Dynamically linked library.
};



#endif // NETVI_DEFINED
